/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.RequestHandlerStack;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class NonResettingRestartException
extends RequestHandlerStack.ReplaceHandlerException {
    private static final long serialVersionUID = 1L;

    public NonResettingRestartException(Class<? extends Page> pageClass) {
        this(pageClass, null);
    }

    public NonResettingRestartException(Class<? extends Page> pageClass, PageParameters params) {
        this(pageClass, params, RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT);
    }

    public NonResettingRestartException(Class<? extends Page> pageClass, PageParameters params, RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        this(NonResettingRestartException.createRequestHandler(pageClass, params, redirectPolicy), true);
    }

    public NonResettingRestartException(String redirectUrl) {
        this(NonResettingRestartException.createUrlRequestHandler(redirectUrl), true);
    }

    public NonResettingRestartException(IRequestHandler handler, boolean removeAll) {
        super(handler, removeAll);
        this.transferResponseMetaData();
    }

    private void transferResponseMetaData() {
        WebResponse originalResponse;
        RequestCycle cycle = RequestCycle.get();
        Response response = cycle.getResponse();
        if (response instanceof IMetaDataBufferingWebResponse && (originalResponse = (WebResponse)cycle.getOriginalResponse()) != response) {
            IMetaDataBufferingWebResponse bufferingWebResponse = (IMetaDataBufferingWebResponse)((Object)response);
            bufferingWebResponse.writeMetaData(originalResponse);
        }
    }

    private static IRequestHandler createRequestHandler(Class<? extends Page> pageClass, PageParameters params, RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        return new RenderPageRequestHandler(new PageProvider(pageClass, params), redirectPolicy);
    }

    private static IRequestHandler createUrlRequestHandler(String redirectUrl) {
        return new RedirectRequestHandler(redirectUrl, 302);
    }
}

