/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.DequeueTagAction;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.util.collections.ArrayListStack;

public final class DequeueContext {
    private final IMarkupFragment markup;
    private int index;
    private ComponentTag next;
    private ArrayListStack<ComponentTag> tags = new ArrayListStack();
    private final boolean skipFirst;
    private ComponentTag first;
    private ArrayListStack<MarkupContainer> containers = new ArrayListStack();

    public DequeueContext(IMarkupFragment markup, MarkupContainer root, boolean skipFirst) {
        this.markup = markup;
        this.skipFirst = skipFirst;
        this.containers.push(root);
        this.next = this.nextTag();
    }

    public Bookmark save() {
        return new Bookmark(this);
    }

    public void restore(Bookmark bookmark) {
        bookmark.restore(this);
    }

    public ComponentTag peekTag() {
        return this.next;
    }

    public ComponentTag takeTag() {
        ComponentTag taken = this.next;
        if (taken == null) {
            return null;
        }
        if (taken.isOpen() && !taken.hasNoCloseTag()) {
            this.tags.push(taken);
        } else if (this.tags.size() > 0 && taken.closes(this.tags.peek())) {
            this.tags.pop();
        }
        this.next = this.nextTag();
        return taken;
    }

    public void skipToCloseTag() {
        while (!this.next.closes(this.tags.peek())) {
            this.next = this.nextTag();
        }
    }

    private ComponentTag nextTag() {
        MarkupElement element;
        if (this.skipFirst && this.first == null) {
            while (this.index < this.markup.size()) {
                element = this.markup.get(this.index);
                if (element instanceof ComponentTag) {
                    this.first = (ComponentTag)element;
                    ++this.index;
                    break;
                }
                ++this.index;
            }
        }
        while (this.index < this.markup.size()) {
            element = this.markup.get(this.index);
            if (element instanceof ComponentTag) {
                ComponentTag tag = (ComponentTag)element;
                if (tag.isOpen() || tag.isOpenClose()) {
                    DequeueTagAction action = this.canDequeueTag(tag);
                    switch (action) {
                        case IGNORE: {
                            break;
                        }
                        case DEQUEUE: {
                            ++this.index;
                            return tag;
                        }
                        case SKIP: {
                            boolean found = false;
                            while (this.index < this.markup.size()) {
                                if (this.markup.get(this.index) instanceof ComponentTag && this.markup.get(this.index).closes(tag)) {
                                    found = true;
                                    break;
                                }
                                ++this.index;
                            }
                            if (!found) {
                                throw new IllegalStateException(String.format("Could not find close tag for tag '%s' in markup: %s ", tag, this.markup));
                            } else {
                                break;
                            }
                        }
                    }
                } else {
                    ComponentTag open;
                    ComponentTag componentTag = open = tag.isClose() ? tag.getOpenTag() : tag;
                    if (!this.skipFirst || this.first == null || open != this.first) {
                        switch (this.canDequeueTag(open)) {
                            case DEQUEUE: {
                                ++this.index;
                                return tag;
                            }
                            case IGNORE: {
                                break;
                            }
                            case SKIP: {
                                throw new IllegalStateException(String.format("Should not see closed tag of skipped open tag '%s' in markup:%s", tag, this.markup));
                            }
                        }
                    }
                }
            }
            ++this.index;
        }
        return null;
    }

    private DequeueTagAction canDequeueTag(ComponentTag open) {
        if (this.containers.size() < 1) {
            throw new IllegalStateException();
        }
        for (int i = this.containers.size() - 1; i >= 0; --i) {
            DequeueTagAction action = ((MarkupContainer)this.containers.get(i)).canDequeueTag(open);
            if (action == null) continue;
            return action;
        }
        return DequeueTagAction.IGNORE;
    }

    public boolean isAtOpenOrOpenCloseTag() {
        ComponentTag tag = this.peekTag();
        return tag != null && (tag.isOpen() || tag.isOpenClose());
    }

    public MarkupContainer peekContainer() {
        return this.containers.peek();
    }

    public void pushContainer(MarkupContainer container) {
        this.containers.push(container);
    }

    public MarkupContainer popContainer() {
        return this.containers.pop();
    }

    public Component findComponentToDequeue(ComponentTag tag) {
        for (int j = this.containers.size() - 1; j >= 0; --j) {
            MarkupContainer container = (MarkupContainer)this.containers.get(j);
            Component child = container.findComponentToDequeue(tag);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static final class Bookmark {
        private final int index;
        private final ComponentTag next;
        private final ArrayListStack<ComponentTag> tags;
        private final ArrayListStack<MarkupContainer> containers;

        private Bookmark(DequeueContext parser) {
            this.index = parser.index;
            this.next = parser.next;
            this.tags = new ArrayListStack(parser.tags);
            this.containers = new ArrayListStack(parser.containers);
        }

        private void restore(DequeueContext parser) {
            parser.index = this.index;
            parser.next = this.next;
            parser.tags = new ArrayListStack<ComponentTag>((Collection<ComponentTag>)this.tags);
            parser.containers = new ArrayListStack<MarkupContainer>((Collection<MarkupContainer>)this.containers);
        }
    }
}

