/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.AbstractWordFinder;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordNotFoundException;

public class DefaultWordFinder
extends AbstractWordFinder {
    public DefaultWordFinder(String inText) {
        super(inText);
    }

    public DefaultWordFinder() {
    }

    public Word next() {
        if (this.nextWord == null) {
            throw new WordNotFoundException("No more words found.");
        }
        this.currentWord.copy(this.nextWord);
        this.setSentenceIterator(this.currentWord);
        boolean finished = false;
        for (int i = this.currentWord.getEnd(); i < this.text.length() && !finished; ++i) {
            if (!this.isWordChar(i)) continue;
            this.nextWord.setStart(i);
            int end = this.getNextWordEnd(this.text, i);
            this.nextWord.setText(this.text.substring(i, end));
            finished = true;
        }
        if (!finished) {
            this.nextWord = null;
        }
        return this.currentWord;
    }

    private int getNextWordEnd(String text, int startPos) {
        if (SpellChecker.beginsAsINETWord(text.substring(startPos))) {
            for (int i = startPos; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isLetterOrDigit(ch)) continue;
                if (ch == '\r' || ch == '\n') {
                    return i;
                }
                if (!Character.isSpaceChar(ch)) continue;
                if (i > 0 && Character.isLetterOrDigit(text.charAt(i - 1))) {
                    return i;
                }
                return i - 1;
            }
            return text.length();
        }
        for (int i = startPos; i < text.length(); ++i) {
            if (this.isWordChar(i)) continue;
            return i;
        }
        return text.length();
    }
}

