// =====================================================================
//  $Id: rpv130.cc,v 1.1 2003/07/11 05:41:34 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TVmeRpv130Module.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<offset> <npulse>" << Tendl;
    Tcerr << "ex) " << argv[ 0 ] << " 0x1000 10" << Tendl;
    return( -1 );
  }
  const Tint rpvoffset = strtol( argv[ 1 ], 0, 0 );
  const Tint npulse = strtol( argv[ 2 ], 0, 0 );

  TVmeRpv130Module rpv130( rpvoffset );

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < npulse; i ++ ) {
    rpv130.Pulse( 0xff );
  }
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
