// =====================================================================
//  $Id: mm7702.cc,v 1.2 2003/07/05 23:55:51 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRs232cKeithley7702Module.hh"
#include "TDataElement.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<device> <nevent>" << Tendl;
    Tcerr << "ex) " << argv[ 0 ] << " /dev/ttyS0 (linux typical) 10" << Tendl;
    return( -1 );
  }
  const Tstring devpath = argv[ 1 ];
  const Tint nevent = strtol( argv[ 2 ], 0, 0 );
  const Tint nchannel = 32;
  TRs232cKeithley7702Module mm7702;
  mm7702.Initialize();
  TDataElement e;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    for ( Tint i = 0; i < nchannel; i ++ ) {
      e.SetID( itostr( i, 0 ) );
      mm7702.FillData( e, i );
      Tcout << e << Tendl;
    }
    mm7702.Clear();
  }
  mm7702.Close();
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
