// =====================================================================
//  $Id: findfast.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );

  TDataRecord record;

  TBenchmark bench;
  bench.Start();
  Tint nelements = 0;
  while ( ( ifile.Read( record ) ) != 0 ) {
    //fast access section 0, segment 0, element 1.
    Tcout << record[0][0][1] << Tendl;
    nelements ++;
  }
  Tcout << nelements << " element(s) have been found out from ";
  Tcout << filename << "." << Tendl;
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
