// =====================================================================
//  $Id: TReadoutIndex.cc,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TReadoutIndex.hh"

TReadoutIndex::TReadoutIndex()
  : Tvector<TReadoutSpecified>()
{;}

TReadoutIndex::~TReadoutIndex()
{;}

TReadoutList* TReadoutIndex::FindReadoutList( const Tstring& id ) const
{
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( (*this)[ i ].GetListID() == id ) {
      return( (*this)[ i ].GetReadoutList() );
    }
  }
  return( 0 );
}

Tvoid TReadoutIndex::AddReadoutList( const Tstring& id, TReadoutList* readoutlist )
{
  TReadoutSpecified spec( id, readoutlist );
  push_back( spec );
  return;
}

Tvoid TReadoutIndex::RemoveReadoutList( Tint index )
{
  erase( begin() + index );
  return;
}

Tint TReadoutIndex::GetSize() const
{
  return( (Tint)size() );
}

Tvoid TReadoutIndex::Clear()
{
  clear();
  return;
}

