// =====================================================================
//  $Id: TModule.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TMODULE_HH
#define __TMODULE_HH

#include "Tglobals.h"

class TDataSegment;
class TDataElement;

class TModule
{

  public:
    enum { tStatusSuccess = 0 };

  protected:
    Tint theNumberOfChannels;
    Tint theStatus;

  public:
    TModule( Tint nchannel = 0 );
    TModule( const TModule& right );
    virtual ~TModule();

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;
    virtual Tvoid FillData( TDataElement& element, Tint channel ) = 0;

  public:
    virtual const TModule& operator=( const TModule& right );
    virtual Tbool operator==( const TModule& right ) const;
    virtual Tbool operator!=( const TModule& right ) const;

  public:
    Tint GetNumberOfChannels() const;
    Tint GetStatus() const;
    Tvoid SetNumberOfChannels( Tint nchannel );
    Tvoid SetStatus( Tint status );
    Tbool IsSuccess() const;

};

inline Tint TModule::GetNumberOfChannels() const
{
  return( theNumberOfChannels );
}

inline Tvoid TModule::SetNumberOfChannels( Tint nchannel )
{
  theNumberOfChannels = nchannel;
  return;
}

inline Tint TModule::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TModule::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TModule::IsSuccess() const
{
  return( ( theStatus >= 0 ) ? Ttrue : Tfalse );
}

#endif
