// =====================================================================
//  $Id: TPrintCurrentWorkingDirectoryCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TPrintCurrentWorkingDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "pwd";
static const Tstring _desc = "print the absolute pathname of the current working directory.";

TPrintCurrentWorkingDirectoryCommand::TPrintCurrentWorkingDirectoryCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TPrintCurrentWorkingDirectoryCommand::~TPrintCurrentWorkingDirectoryCommand()
{;}

Tvoid TPrintCurrentWorkingDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  static const Tstring head = "TPrintCurrentWorkingDirectoryCommand::Execute: ";
  if ( ui ) {
    Tcout << ui -> GetCurrentWorkingDirectory() << Tendl;
  } else {
    Tcerr << head << "UserInterface doesn't exist." << Tendl;
  }
  return;
}
