// =====================================================================
//  $Id: St02SinglePixel.hh,v 1.1 2003/07/11 05:34:15 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __ST02SINGLEPIEL_HH
#define __ST02SINGLEPIEL_HH

#include "Tglobals.h"

class St02SinglePixel
{

  protected:
    Tint theHorizontalID;
    Tint theVerticalID;
    Tdouble theSignal;
    Tdouble theDark;
    Tdouble theRms;

  public:
    St02SinglePixel( Tint h = 0, Tint v = 0, Tdouble signal = 0.0, Tdouble dark = 0.0, Tdouble rms = 0.0 );
    St02SinglePixel( const St02SinglePixel& right );
    ~St02SinglePixel();

  public:
    const St02SinglePixel& operator=( const St02SinglePixel& right );
    Tbool operator==( const St02SinglePixel& right ) const;
    Tbool operator!=( const St02SinglePixel& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const St02SinglePixel& right );
    friend Tistream& operator>>( Tistream& tis, St02SinglePixel& right );

  public:
    Tint GetHorizontalID() const;
    Tint GetVerticalID() const;
    Tdouble GetSignal() const;
    Tdouble GetDark() const;
    Tdouble GetRms() const;
    Tvoid SetHorizontalID( Tint id );
    Tvoid SetVerticalID( Tint id );
    Tvoid SetSignal( Tdouble signal );
    Tvoid SetDark( Tdouble dark );
    Tvoid SetRms( Tdouble rms );

};

inline Tint St02SinglePixel::GetHorizontalID() const
{
  return( theHorizontalID );
}

inline Tint St02SinglePixel::GetVerticalID() const
{
  return( theVerticalID );
}

inline Tdouble St02SinglePixel::GetSignal() const
{
  return( theSignal );
}

inline Tdouble St02SinglePixel::GetDark() const
{
  return( theDark );
}

inline Tdouble St02SinglePixel::GetRms() const
{
  return( theRms );
}

inline Tvoid St02SinglePixel::SetHorizontalID( Tint id )
{
  theHorizontalID = id;
  return;
}

inline Tvoid St02SinglePixel::SetVerticalID( Tint id )
{
  theVerticalID = id;
  return;
}

inline Tvoid St02SinglePixel::SetSignal( Tdouble signal )
{
  theSignal = signal;
  return;
}

inline Tvoid St02SinglePixel::SetDark( Tdouble dark )
{
  theDark = dark;
  return;
}

inline Tvoid St02SinglePixel::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

#endif
