// =====================================================================
//  $Id: St01SinglePixelInterface.hh,v 1.1 2003/06/27 19:16:43 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __ST01SINGLEPIXELINTERFACE_HH
#define __ST01SINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "St01SinglePixelList.hh"
#include "TDataMultiplicity.hh"

class St01BadChannelMap;

class St01SinglePixelInterface
{

  private:
    St01SinglePixelList theSinglePixelList;
    St01BadChannelMap* theBadChannelMap;

  public:
    St01SinglePixelInterface( const Tstring& filename );
    St01SinglePixelInterface( const Tstring& dark, const Tstring& source );
    ~St01SinglePixelInterface();

  public:
    const St01SinglePixelList& GetSinglePixelList() const;
    St01SinglePixelList& GetSinglePixelList();
    St01BadChannelMap* GetBadChannelMap() const;

  private:
    Tbool isThisOverThreshold( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThisSinglePixel( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereOverThresholdAroundHere( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereBadChannelAroundHere( Tint row, Tint col ) const;
    Tbool isThisBadChannel( Tint row, Tint col ) const;

};

inline const St01SinglePixelList& St01SinglePixelInterface::GetSinglePixelList() const
{
  return( theSinglePixelList );
}

inline St01SinglePixelList& St01SinglePixelInterface::GetSinglePixelList()
{
  return( theSinglePixelList );
}

inline St01BadChannelMap* St01SinglePixelInterface::GetBadChannelMap() const
{
  return( theBadChannelMap );
}

#endif
