// =====================================================================
//  $Id: St00PureEventViewCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "St00PureEventViewCommand.hh"
#include "St00RunAction.hh"

static const Tstring _name = "/local/pureeventview";
static const Tstring _desc = "view histogram.";

St00PureEventViewCommand::St00PureEventViewCommand()
  : TCommand( _name, _desc )
{;}

St00PureEventViewCommand::~St00PureEventViewCommand()
{;}

Tvoid St00PureEventViewCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  St00RunAction* action = (St00RunAction*)( theRunManager -> GetRunAction() );
  Tstring runid = theRunManager -> GetRun().GetStringRunID();
  Tstring title = Twquote + "pure data, run " + runid + Twquote;

  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/st00pureeventview" );
  args.push_back( filename );
  args.push_back( title );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
