// =====================================================================
//  $Id: Rs00EventAction.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00EventAction.hh"
#include "Rs00RunAction.hh"

Rs00EventAction::Rs00EventAction()
{;}

Rs00EventAction::~Rs00EventAction()
{;}

TReadoutList* Rs00EventAction::WaitEvent()
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint rate = envtable.GetIntegerValue( "RS00_KEITHLEY_SAMPLING_RATE" );
  sleep( rate );
  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid Rs00EventAction::EndOfEventAction( TEvent& anEvent )
{
  Rs00RunAction* action =
    (Rs00RunAction*)( theRunManager -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();
  ofile -> Write( anEvent.GetDataRecord() );
  theCrate -> Update();
  return;
}
