// =====================================================================
//  $Id: Bt00RunAction.hh,v 1.2 2003/06/27 10:04:26 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __BT00RUNACTION_HH
#define __BT00RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class Bt00RunSummary;

class Bt00RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    Bt00RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    Bt00RunAction();
    ~Bt00RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    Bt00RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );

};

inline TOutputObjectFile* Bt00RunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline Bt00RunSummary* Bt00RunAction::GetRunSummary() const
{
  return( theRunSummary );
}

inline TOutputHtmlFileStream& Bt00RunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

#endif
