// =====================================================================
//  $Id: TDataInflation.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TDATAINFLATION_HH
#define __TDATAINFLATION_HH
#ifdef __CLDAQ_ZLIB_USE

#include "Tglobals.h"

class TDataInflation
{

  private:
    enum { tDefaultBufferSize = 1024 * 1024 };

  private:
    Tzstream theInflationStream;
    Tint theStatus;
    Tbyte* theOutputBuffer;
    Tint theSizeOfOutputBuffer;
    Tvoid* theInflatedData;
    Tint theSizeOfInflatedData;

  public:
    TDataInflation( Tint bufsize = tDefaultBufferSize );
    TDataInflation( const TDataInflation& right );
    ~TDataInflation();

  public:
    const TDataInflation& operator=( const TDataInflation& right );

  public:
    Tvoid Decompress( Tvoid* input, Tint nbyte );

  public:
    const Tzstream& GetInflationStream() const;
    Tzstream& GetInflationStream();
    Tint GetStatus() const;
    Tint GetSizeOfOutputBuffer() const;
    Tvoid* GetInflatedData() const;
    Tint GetSizeOfInflatedData() const;
    Tvoid SetOutputBuffer( Tint bufsize );

};

inline const Tzstream& TDataInflation::GetInflationStream() const
{
  return( theInflationStream );
}

inline Tzstream& TDataInflation::GetInflationStream()
{
  return( theInflationStream );
}

inline Tint TDataInflation::GetStatus() const
{
  return( theStatus );
}

inline Tint TDataInflation::GetSizeOfOutputBuffer() const
{
  return( theSizeOfOutputBuffer );
}

inline Tvoid* TDataInflation::GetInflatedData() const
{
  return( theInflatedData );
}

inline Tint TDataInflation::GetSizeOfInflatedData() const
{
  return( theSizeOfInflatedData );
}

#endif
#endif
