// =====================================================================
//  $Id: TObjectStream.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TOBJECTSTREAM_HH
#define __TOBJECTSTREAM_HH

#include "Tglobals.h"

class TObjectFilter;

class TObjectStream
{

  protected:
    TObjectFilter* theObjectFilter;
    Tstream_t theStreamType;
    Tint theDataSize;
    Tint theLastDataSize;
    Tint theTotalDataSize;

  public:
    TObjectStream( Tstream_t streamtype = tUnknownStream );
    TObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TObjectStream();

  public:
    Tstream_t GetStreamType() const;
    Tvoid SetStreamType( Tstream_t streamtype );
    TObjectFilter* GetObjectFilter() const;
    Tvoid SetObjectFilter( TObjectFilter* filter );
    Tbool HasFilter() const;
    Tint GetDataSize() const;
    Tint GetLastDataSize() const;
    Tvoid SetDataSize( Tint datasize );
    Tvoid SetLastDataSize( Tint datasize );
    Tint GetTotalDataSize() const;

};

inline Tint TObjectStream::GetDataSize() const
{
  return( theDataSize );
}

inline Tint TObjectStream::GetLastDataSize() const
{
  return( theLastDataSize );
}

inline Tvoid TObjectStream::SetDataSize( Tint datasize )
{
  theDataSize = datasize;
  return;
}

inline Tvoid TObjectStream::SetLastDataSize( Tint datasize )
{
  theLastDataSize = datasize;
  return;
}

inline Tstream_t TObjectStream::GetStreamType() const
{
  return( theStreamType );
}

inline Tvoid TObjectStream::SetStreamType( Tstream_t streamtype )
{
  theStreamType = streamtype;
  return;
}

inline TObjectFilter* TObjectStream::GetObjectFilter() const
{
  return( theObjectFilter );
}

inline Tvoid TObjectStream::SetObjectFilter( TObjectFilter* filter )
{
  theObjectFilter = filter;
  return;
}

inline Tbool TObjectStream::HasFilter() const
{
  return( ( theObjectFilter != 0 ) ? Ttrue : Tfalse );
}

inline Tint TObjectStream::GetTotalDataSize() const
{
  return( theTotalDataSize );
}

#endif
