// =====================================================================
//  $Id: TInputObjectSharedMemory.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TINPUTOBJECTSHAREDMEMORY_HH
#define __TINPUTOBJECTSHAREDMEMORY_HH

#include "Tglobals.h"
#include "TObjectSharedMemory.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSharedMemory
  : public TObjectSharedMemory, public TInputObjectStream
{

  private:
    Tbool theReadSuccessFlag;

  public:
    TInputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TInputObjectSharedMemory( TObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TInputObjectSharedMemory();

  public:
    Tint Read( TStreamableObject& object );

  public:
    Tbool IsReadSuccess() const;

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );
};

inline Tbool TInputObjectSharedMemory::IsReadSuccess() const
{
  return( theReadSuccessFlag );
}

#endif
