// =====================================================================
//  $Id: TSoftwareInterruptRegisterModule.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TSOFTWAREINTERRUPTREGISTERMODULE_HH
#define __TSOFTWAREINTERRUPTREGISTERMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareInterruptRegisterModule
  : public TSoftwareModule
{

  private:
    Tint theInterruptRegister;
    Tint theInterruptMaskRegister;
    Tint theFrequency;

  public:
    TSoftwareInterruptRegisterModule( Tint nch = 2, Tint frequency = 1 );
    TSoftwareInterruptRegisterModule( const TSoftwareInterruptRegisterModule& right );
    ~TSoftwareInterruptRegisterModule();

  public:
    const TSoftwareInterruptRegisterModule& operator=( const TSoftwareInterruptRegisterModule& right );
    Tbool operator==( const TSoftwareInterruptRegisterModule& right ) const;
    Tbool operator!=( const TSoftwareInterruptRegisterModule& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tint ReadInterruptRegister();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint GetInterruptRegister() const;
    Tint GetInterruptMaskRegister() const;
    Tint GetFrequency() const;
    Tvoid SetInterruptRegister( Tint val );
    Tvoid SetInterruptMaskRegister( Tint val );
    Tvoid SetFrequency( Tint frequency );

};

inline Tint TSoftwareInterruptRegisterModule::GetInterruptRegister() const
{
  return( theInterruptRegister );
}

inline Tint TSoftwareInterruptRegisterModule::GetInterruptMaskRegister() const
{
  return( theInterruptMaskRegister );
}

inline Tint TSoftwareInterruptRegisterModule::GetFrequency() const
{
  return( theFrequency );
}

inline Tvoid TSoftwareInterruptRegisterModule::SetInterruptRegister( Tint val )
{
  theInterruptRegister = val;
  return;
}

inline Tvoid TSoftwareInterruptRegisterModule::SetInterruptMaskRegister( Tint val )
{
  theInterruptMaskRegister = val;
  return;
}

inline Tvoid TSoftwareInterruptRegisterModule::SetFrequency( Tint frequency )
{
  theFrequency = frequency;
  return;
}

#endif
