// =====================================================================
//  $Id: TRs232cKeithley2700Module.cc,v 1.3 2003/07/10 17:48:23 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRs232cKeithley2700Module.hh"

TRs232cKeithley2700Module::TRs232cKeithley2700Module( const Tstring devfile, Tint nchannel )
  : TRs232cModule( devfile, nchannel )
{;}

TRs232cKeithley2700Module::TRs232cKeithley2700Module( Tint nchannel, Tstring devfile )
  : TRs232cModule( nchannel, devfile )
{;}

TRs232cKeithley2700Module::TRs232cKeithley2700Module( const TRs232cKeithley2700Module& right )
  : TRs232cModule( right )
{;}

TRs232cKeithley2700Module::~TRs232cKeithley2700Module()
{;}

Tvoid TRs232cKeithley2700Module::defineClearMethod( Tint channel )
{
  //顼塼򥯥ꥢ
  Write( "*CLS" );
  return;
}

Tvoid TRs232cKeithley2700Module::defineUpdateMethod( Tint channel )
{
  Clear();
  return;
}

Tvoid TRs232cKeithley2700Module::defineInitializeMethod( Tint channel )
{
  //ǥե᤹
  Write( "*RST" );

  //BEEP OFF
  //Write( ":SYST:BEEP OFF" );

  //󥵤μ󥰥륯ȤǤޤͤФʤʤ
  Write( ":SENS:FUNC 'RES'" );

  //ʬ®٤PLCñ̤
  //Write( ":SENS:RES:NPLC 1" );

  //ʬ®٤ñ̤
  //Write( ":SENS:RES:APER 1" );

  //ؤ
  //Write( "SENS:RES:RANG 120e6" );

  //
  //Write( "SENS:RES:DIG 5" );

  //AUTOON
  Write( "SENS:RES:RANG:AUTO ON" );

  //ǡǻ
  Write( ":FORM:ELEM READ" );

  return;
}

Tvoid TRs232cKeithley2700Module::defineReadMethod( Tint channel )
{
  Write( ":READ?" );
  return;
}

Tbool TRs232cKeithley2700Module::modifyData( const Tstring& accept, Tdouble& databuf ) const
{
  databuf = strtod( accept.c_str(), 0 );
  return( Ttrue );
}
