// =====================================================================
//  $Id: TCamacOutputRegisterModule.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TCAMACOUTPUTREGISTERMODULE_HH
#define __TCAMACOUTPUTREGISTERMODULE_HH

#include "Tglobals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;

class TCamacOutputRegisterModule
  : public TCamacModule
{

  public:
    TCamacOutputRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tdata_t datalen = t16bitModule );
    TCamacOutputRegisterModule( const TCamacOutputRegisterModule& right );
    ~TCamacOutputRegisterModule();

  public:
    const TCamacOutputRegisterModule& operator=( const TCamacOutputRegisterModule& right );
    Tbool operator==( const TCamacOutputRegisterModule& right ) const;
    Tbool operator!=( const TCamacOutputRegisterModule& right ) const;
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint Pulse( Tint data );
    Tint Level( Tint data );

};

#endif
