// =====================================================================
//  $Id: TReadFileCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TReadFileCommand.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"

static const Tstring _name = "/option/readfile";
static const Tstring _desc = "open a object file, dump to screen.\nexample> /option/readfile filename.drec";

TReadFileCommand::TReadFileCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TReadFileCommand::~TReadFileCommand()
{;}

Tvoid TReadFileCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  const Tstring filename = arguments[ 0 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  while ( ( ifile -> Read( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile -> GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  delete ifile;

  return;
}
