// =====================================================================
//  $Id: TInitializeRunInformationModuleCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TInitializeRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/initinfo";
static const Tstring _desc = "initialize run information in the table.";

TInitializeRunInformationModuleCommand::TInitializeRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TInitializeRunInformationModuleCommand::~TInitializeRunInformationModuleCommand()
{;}

Tvoid TInitializeRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }

  theRunInformationModule -> Initialize();
  return;
}
