// =====================================================================
//  $Id: St01DataRecordConversion.cc,v 1.1 2003/06/27 19:16:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "St01DataRecordConversion.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"

St01DataRecordConversion::St01DataRecordConversion()
  : St01Map( "" ), theConversionSuccess( Tfalse )
{;}

St01DataRecordConversion::~St01DataRecordConversion()
{;}

TDataMultiplicity& St01DataRecordConversion::Convert( const TDataRecord& record )
{
  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataElement e;
  if ( record.FindDataElement( fadcidset, e ) ) {
    Tshort* data = e.GetShortData();
    Tint ndata = e.GetNumberOfPrimitives();
    FillMap( data, ndata );
    theConversionSuccess = Ttrue;
  } else {
    theConversionSuccess = Tfalse;
  }

  return( theMap );
}
