// =====================================================================
//  $Id: regex3.cc,v 1.2 2004/01/29 04:46:40 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: regex3.cc,v $
//  Revision 1.2  2004/01/29 04:46:40  goiwai
//  TRegularExpressionTUtillitiesѹˤΤǤ.
//
//  Revision 1.1  2003/12/05 05:22:06  goiwai
//  HTMLե뤫󥯤ȴޤ.
//  ̩ʰפϹԤʤäƤޤ.
//
// =====================================================================
#include "TRegularExpression.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  const Tstring usage =
    "regex3 - (easy)Find anchors from HTML file."
    "\n"
    "Usage: regex3 [FILE]..."
    "\n"
    "\t"
    "% regex3 *.html";
  TArgument arg( argc, argv, usage );
  if ( arg.GetNumberOfElements() == 0 ) {
    arg.ShowUsage();
  }

  const Tstring pattern = "href *= *[\'\"](http://.*)[\'\"]";

  Tcout << "PATTERN: \"" << pattern << "\"" << Tendl;
  TRegularExpression regex( pattern );
  for ( Tint i = 0; i < arg.GetNumberOfElements(); i ++ ) {
    const Tint buflen = 1024;
    Tchar buf[ buflen ];
    Tifstream ifs( arg[i].c_str() );
    while ( ifs.getline( buf, buflen ) ) {
      Tstring source = buf;
      TstringList s = regex.GetSubMatch( source );
      if ( !s.empty() ) {
        Tcout << arg[i] << ": " << s[0] << Tendl;
      }
    }
    ifs.close();
  }

  return 0;
}
