// =====================================================================
//  $Id: compress.cc,v 1.5 2003/12/06 11:09:11 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: compress.cc,v $
//  Revision 1.5  2003/12/06 11:09:11  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/11/29 14:44:10  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataDeflation.hh"
#include "TArgument.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
#ifdef __CLDAQ_ZLIB_USE
  const Tstring usage = 
    "Usage: compress <INPUT> <OUTPUT>"
    "\n"
    "\n"
    "Mandatory arguments to long options are mandatory for short options too.";
  TArgument arg( argc, argv, usage );
  if ( arg.GetNumberOfElements() != 2 ) {
    arg.ShowUsage();
  }
  const Tstring ifname = arg.GetElement( 0 );
  const Tstring ofname = arg.GetElement( 1 );

  TDataDeflation deflation;

  const Tint bufsize = 1024;
  Tbyte input[ bufsize ]; 

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  TBenchmark bench;
  bench.Start();
  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( (Tchar*)input, bufsize );
    if ( ifs.gcount() < bufsize ) {
      // եå⤪ʤǸ˰Ԥʤ
      // ٸƤӽФȤ褯ʤ
      deflation.Compress( input, ifs.gcount(), Ttrue );
    } else {
      // ̾Ϥ
      deflation.Compress( input, ifs.gcount() );
    }
    ofs.write( (Tchar*)deflation.GetDeflatedData(), deflation.GetSizeOfDeflatedData() );
  }
  bench.Stop();
  Tcout << bench << Tendl;

  ifs.close();
  ofs.close();
#endif
  return 0;
}
