// =====================================================================
//  $Id: TReadoutSpecified.cc,v 1.4 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TReadoutSpecified.cc,v $
//  Revision 1.4  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutSpecified.hh"

TReadoutSpecified::TReadoutSpecified()
  : theListID(), theReadoutList( 0 )
{;}

TReadoutSpecified::TReadoutSpecified( const Tstring& id, TReadoutList* list )
  : theListID( id ), theReadoutList( list )
{;}

TReadoutSpecified::TReadoutSpecified( const TReadoutSpecified& right )
  : theListID( right.theListID ), theReadoutList( right.theReadoutList )
{;}

TReadoutSpecified::~TReadoutSpecified()
{;}

const TReadoutSpecified& TReadoutSpecified::operator=( const TReadoutSpecified& right )
{
  theListID = right.theListID;
  theReadoutList = right.theReadoutList;
  return *this;
}

Tbool TReadoutSpecified::operator==( const TReadoutSpecified& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theListID == right.theListID );
  retval &= ( theReadoutList == right.theReadoutList );
  return retval;
}

Tbool TReadoutSpecified::operator!=( const TReadoutSpecified& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theListID != right.theListID );
  retval |= ( theReadoutList != right.theReadoutList );
  return retval;
}

Tostream& operator<<( Tostream& tos, const TReadoutSpecified& right )
{
  tos << "ID: " << right.theListID << ", " << right.theReadoutList << Tflush;
  return tos;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TReadoutSpecified)
#endif
