// =====================================================================
/*!
//
//  \file TSoftwareFlashAdcModule.hh
//  \brief This file contains the TSoftwareFlashAdcModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareFlashAdcModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TSoftwareFlashAdcModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSOFTWAREFLASHADCMODULE_HH
#define CLDAQ__TSOFTWAREFLASHADCMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareFlashAdcModule
// \brief This is the TSoftwareFlashAdcModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareFlashAdcModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareFlashAdcModule
  : public TSoftwareModule
{

  private:
    enum { tDefaultSampling = 62500 };
    enum { tDefaultChannel = 1 };

  private:
    Tint theNumberOfSampling;

  public:
    TSoftwareFlashAdcModule( Tint nchannel = tDefaultChannel, Tint nsampling = tDefaultSampling );
    TSoftwareFlashAdcModule( const TSoftwareFlashAdcModule& right ); 
   ~TSoftwareFlashAdcModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSoftwareFlashAdcModule& operator=( const TSoftwareFlashAdcModule& right );
    Tbool operator==( const TSoftwareFlashAdcModule& right ) const;
    Tbool operator!=( const TSoftwareFlashAdcModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsampling );

  protected:
    Tvoid setParameters();
    Tvoid fillValue();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSoftwareFlashAdcModule,0)
#endif

};

inline Tint TSoftwareFlashAdcModule::GetNumberOfSampling() const
{
  return theNumberOfSampling;
}

inline Tvoid TSoftwareFlashAdcModule::SetNumberOfSampling( Tint nsampling )
{
  theNumberOfSampling = nsampling;
  return;
}

#endif
