#! /bin/sh

sys="TSystemClock.hh TSystemClock.cc TSystemTimer.hh TSystemTimer.cc TDataDeflation.hh TDataDeflation.cc TDataInflation.hh TDataInflation.cc TSystemLogging.hh TSystemLogging.cc TFileProperty.hh TFileProperty.cc"

setup_clean() {
    rm -f $sys
    rm -f T*.hh T*.cc
    rm -f CINT.cxx CINT.h
}

setup_link() {
    if test -z "$CLDAQ_INSTALL"; then
	echo "CLDAQ_INSTALL: Undefined variable."
	exit 1
    fi

    for f in $sys; do
	ln -fs $CLDAQ_INSTALL/source/system/$f .
    done

    ln -fs $CLDAQ_INSTALL/source/datarecord/T*.hh .
    ln -fs $CLDAQ_INSTALL/source/datarecord/T*.cc .

    ln -fs $CLDAQ_INSTALL/source/persistency/T*.hh .
    ln -fs $CLDAQ_INSTALL/source/persistency/T*.cc .
}

case "$1" in
    clean)
        setup_clean
        ;;
    link)
        setup_link
        ;;
    *)
        echo "Usage: $0 <clean|link>"
        ;;
esac

exit 0
