// =====================================================================
//  $Id: St02BadChannelMap.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: St02BadChannelMap.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02BadChannelMap.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St02DataRecordConversion.hh"

St02BadChannelMap::St02BadChannelMap( const Tstring& filename )
  : St02Map( filename ), theOfflineDarkRmsMap( theInputFileName )
{
  // RMS礭ΤХåɥͥˤ
  const TDataMultiplicity& rmsmap = theOfflineDarkRmsMap.GetMap();
  Tdouble threshold = theEnvironmentVariableTable.GetDoubleValue( "ST02_BAD_THRESHOLD_RMS" );
  for ( Tint row = 0; row < rmsmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < rmsmap.num_col(); col ++ ) {
      if ( rmsmap[ row ][ col ] > threshold ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }


  // overflow,underflowޤˤΤХåɥͥˤ
  const St02OfflineDarkAverageMap& ave = theOfflineDarkRmsMap.GetOfflineDarkAverageMap();
  const TDataMultiplicity& cntmap = ave.GetCounterMap();
  Tdouble needevent =
    ave.GetNumberOfFrames() / theEnvironmentVariableTable.GetDoubleValue( "ST02_BAD_OVERFLOW" );
  for ( Tint row = 0; row < cntmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < cntmap.num_col(); col ++ ) {
      if ( cntmap[ row ][ col ] < needevent ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }

}

St02BadChannelMap::~St02BadChannelMap()
{;}

Tbool St02BadChannelMap::IsBadChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::IsBadChannel(): invalid row." << Tendl;
    return Tfalse;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::IsBadChannel(): invalid column." << Tendl;
    return Tfalse;
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

Tbool St02BadChannelMap::IsGoodChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::IsGoodChannel(): invalid row." << Tendl;
    return Tfalse;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::IsGoodChannel(): invalid column." << Tendl;
    return Tfalse;
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return Tfalse;
  } else {
    return Ttrue;
  }
}

Tvoid St02BadChannelMap::SetBadChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::SetBadChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::SetBadChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 1.0;

  return;
}

Tvoid St02BadChannelMap::SetGoodChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::SetGoodChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St02BadChannelMap::SetGoodChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 0.0;

  return;
}

Tint St02BadChannelMap::GetNumberOfBadChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 1.0 ) {
	num ++;
      }
    }
  }
  return num;
}

Tint St02BadChannelMap::GetNumberOfGoodChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 0.0 ) {
	num ++;
      }
    }
  }
  return num;
}
