// =====================================================================
//  $Id: DaqRunAction.cc,v 1.1 2006/02/15 07:04:51 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: DaqRunAction.cc,v $
//  Revision 1.1  2006/02/15 07:04:51  goiwai
//  ɥѤ˺Ǥñ꥽եȥDAQץޤ
//
// =====================================================================
#include "TRunManager.hh"
#include "TRun.hh"
#include "DaqRunAction.hh"

#include "TOutputObjectFile.hh"
#include "TCrate.hh"

DaqRunAction::DaqRunAction()
  : TRunAction(), ofile(0)
{;}

DaqRunAction::~DaqRunAction()
{;}

Tvoid DaqRunAction::Start( TRun& aRun )
{
  // 󳫻ϻ⥸塼
  theCrate->Initialize();

  // 󳫻ϻե륹ȥ꡼
  ofile = new TOutputObjectFile("demo.drec");

  return;
}

Tvoid DaqRunAction::Stop( TRun& aRun )
{
  // λե륹ȥ꡼
  delete ofile;

  return;
}

Tvoid DaqRunAction::Suspend( TRun& aRun )
{
  // /run/suspendޥɤбư
  Tcout << "Run #" << aRun.GetRunID() << " suspend." << Tendl;
  return;
}

Tvoid DaqRunAction::Resume( TRun& aRun )
{
  // /run/resumeޥɤбư
  Tcout << "Run #" << aRun.GetRunID() << " resume." << Tendl;
  return;
}
