// =====================================================================
//  $Id: DaqReadoutBookDefinition.cc,v 1.1 2006/02/15 07:04:51 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: DaqReadoutBookDefinition.cc,v $
//  Revision 1.1  2006/02/15 07:04:51  goiwai
//  ɥѤ˺Ǥñ꥽եȥDAQץޤ
//
// =====================================================================
#include "TReadoutBook.hh"
#include "DaqReadoutBookDefinition.hh"

#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"

DaqReadoutBookDefinition::DaqReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

DaqReadoutBookDefinition::~DaqReadoutBookDefinition()
{;}

TReadoutBook* DaqReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();

  // ɤ߽ФȤ˥⥸塼бĤ
  TReadoutSegment clock(theCrate->GetModule("CLOCK"), "CLOCK");
  TReadoutSegment timer(theCrate->GetModule("TIMER"), "TIMER");
  TReadoutSegment interrupt(theCrate->GetModule("INTERRUPT"), "INTERRUPT");
  TReadoutSegment adc(theCrate->GetModule("ADC"), "ADC");
  TReadoutSegment scaler(theCrate->GetModule("SCALER"), "SCALER");

  // ADCȥꥬѤɤ߽ФꥹȤ
  TReadoutList* adc_trigger = new TReadoutList("ADC TRIGGER");
  TReadoutSection adc_event("ADC EVENT");
  adc_event.push_back(clock);
  adc_event.push_back(timer);
  adc_event.push_back(interrupt);
  adc_event.push_back(adc);
  adc_trigger->push_back(adc_event);

  // SCALERȥꥬѤɤ߽ФꥹȤ
  TReadoutList* scaler_trigger = new TReadoutList("SCALER TRIGGER");
  TReadoutSection scaler_event("SCALER EVENT");
  scaler_event.push_back(clock);
  scaler_event.push_back(timer);
  scaler_event.push_back(interrupt);
  scaler_event.push_back(scaler);
  scaler_trigger->push_back(scaler_event);

  // ɤ߽Ф֥åɤ߽ФꥹȤä
  book->AddReadoutList(adc_trigger);
  book->AddReadoutList(scaler_trigger);

  return book;
}
