// =====================================================================
//  $Id: DaqEventAction.cc,v 1.1 2006/02/15 07:04:51 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: DaqEventAction.cc,v $
//  Revision 1.1  2006/02/15 07:04:51  goiwai
//  ɥѤ˺Ǥñ꥽եȥDAQץޤ
//
// =====================================================================
#include "TEventManager.hh"
#include "TEvent.hh"
#include "DaqEventAction.hh"

#include "TSoftwareInterruptRegisterModule.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TOutputObjectFile.hh"
#include "TRunManager.hh"
#include "TRandomFlat.hh"
#include "DaqRunAction.hh"

DaqEventAction::DaqEventAction()
  : TEventAction()
{;}

DaqEventAction::~DaqEventAction()
{;}

TReadoutList* DaqEventAction::WaitTrigger()
{
  // ȥꥬԤư

  TSoftwareInterruptRegisterModule* interrupt =
    (TSoftwareInterruptRegisterModule*)(theCrate->GetModule("INTERRUPT"));

  enum { NOSIGNAL = 0x0000, ADC = 0x0001, SCALER = 0x0002, BOTH = 0x0003 };

  // 󥿥ץȥ쥸ݡ󥰤Ǹĥ
  while (1) {
    Tint bit = interrupt->ReadInterruptRegister();

    // ADCޤξΥե饰ΩäƤADCȥꥬ
    if (bit == ADC || bit == BOTH) {
      return theReadoutBook->GetReadoutList("ADC TRIGGER");

    // SCALERΥե饰ΩäƤSCALERȥꥬ
    } else if (bit == SCALER) {
      return theReadoutBook->GetReadoutList("SCALER TRIGGER");
    } else {
      continue;
    }
  }
}

Tvoid DaqEventAction::AtFirst( TEvent& anEvent )
{
  TSoftwareInterruptRegisterModule* interrupt =
    (TSoftwareInterruptRegisterModule*)(theCrate->GetModule("INTERRUPT"));

  // ٥ȥ롼׳ϻ˥ȥꥬ졼ȤŬ(1-10Hz)
  interrupt->SetFrequency(TRandomFlat::shootInt(1,10));

  // ޥԤ8bitξ6bitϥե饰Ωʤ褦ˤ
  // Ĥޤͥ0(ADC)1(SCALER)Τͭ
  interrupt->SetInterruptMaskRegister(0x00fc);

  return;
}

Tvoid DaqEventAction::AtLast( TEvent& anEvent )
{
  DaqRunAction* action =
    (DaqRunAction*)(theRunManager->GetRunAction());
  TOutputObjectFile* ofile = action->GetOutputFile();

  // ٥˼ǡϿ
  TDataRecord record = anEvent.GetDataRecord();
  ofile->Write(record);

  // ADCȥꥬʤADC򹹿
  if (record.GetID() == "ADC TRIGGER") {
    theCrate->GetModule("ADC")->Update();

  // SCALERȥꥬʤSCALER򹹿
  } else if (record.GetID() == "SCALER TRIGGER") {
    theCrate->GetModule("SCALER")->Update();
  }

  // TIMER,CLOCK,INTERRUPT襤٥ȹ
  theCrate->GetModule("TIMER")->Update();
  theCrate->GetModule("CLOCK")->Update();
  theCrate->GetModule("INTERRUPT")->Clear();

  return;
}
