/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;

public class RuleResourceValidPermitTest {
	@Mocked
	private TestConstraintValidatorContext context;
	
	@Mocked
	private TestConstraintViolationBuilder builder;

	@Mocked
	private TestNodeBuilderDefinedContext definedContext;
	
	@Mocked
	private TestNodeBuilderCustomizableContext customizableContext;
	
	@Mocked
	private TestNodeContextBuilder nodeContextBuilder;
	
	@Test
	public void testIsValid_OK_ResourceZERO() {
		Policy policy = new Policy();
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		
		RuleResourceValidPermit.Validator validator = new RuleResourceValidPermit.Validator();
		
		boolean actual = validator.isValid(model, null);
		assertThat(actual, is(true));
	}
	
	@Test
	public void testIsValid_OK() {
		Policy policy = new Policy();
		
		Resource resource1 = new Resource();
		resource1.setGetPermit(Permit.ALLOW);
		policy.getResources().add(resource1);
		Resource resource2 = new Resource();
		resource2.setGetPermit(Permit.DENY);
		policy.getResources().add(resource2);
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		
		RuleResourceValidPermit.Validator validator = new RuleResourceValidPermit.Validator();
		
		boolean actual = validator.isValid(model, null);
		assertThat(actual, is(true));
	}
	
	@Test
	public void testIsValid_NG() {
		Policy policy = new Policy();
		Resource resource1 = new Resource();
		resource1.setResourceURL("http://www.example.com/");
		policy.getResources().add(resource1);
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);

		new Expectations() {
			{
				new TestConstraintValidatorContext();
				new TestConstraintViolationBuilder();
				new TestNodeBuilderDefinedContext();
				new TestNodeBuilderCustomizableContext();
				new TestNodeContextBuilder();
				context.disableDefaultConstraintViolation();
				context.getDefaultConstraintMessageTemplate();
				result = "template2";
				context.buildConstraintViolationWithTemplate("template2http://www.example.com/");
				result = builder;
				builder.addNode("policy");
				result = definedContext;
				definedContext.addNode("resources");
				result = customizableContext;
				customizableContext.addNode("resourcesUrl");
				result = customizableContext;
				customizableContext.inIterable();
				result = nodeContextBuilder;
				nodeContextBuilder.atIndex(0);
				result = definedContext;
				definedContext.addConstraintViolation();
			}
		};

		TestConstraintValidatorContext context = new TestConstraintValidatorContext();
		new TestConstraintViolationBuilder();
		new TestNodeBuilderDefinedContext();
		new TestNodeBuilderCustomizableContext();
		new TestNodeContextBuilder();
		
		RuleResourceValidPermit.Validator validator = new RuleResourceValidPermit.Validator();
		boolean actual = validator.isValid(model, context);
		assertThat(actual, is(false));
	}
	
	private static class TestConstraintValidatorContext implements ConstraintValidatorContext {
		@Override
		public void disableDefaultConstraintViolation() {
		}

		@Override
		public String getDefaultConstraintMessageTemplate() {
			return null;
		}

		@Override
		public ConstraintViolationBuilder buildConstraintViolationWithTemplate(
				String messageTemplate) {
			return null;
		}
	}
	
	private static class TestConstraintViolationBuilder implements ConstraintViolationBuilder {
		@Override
		public NodeBuilderDefinedContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderDefinedContext implements NodeBuilderDefinedContext {
		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderCustomizableContext implements NodeBuilderCustomizableContext {
		@Override
		public NodeContextBuilder inIterable() {
			return null;
		}

		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeContextBuilder implements NodeContextBuilder {
		@Override
		public NodeBuilderDefinedContext atKey(Object key) {
			return null;
		}

		@Override
		public NodeBuilderDefinedContext atIndex(Integer index) {
			return null;
		}

		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
}
