/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import static org.hamcrest.CoreMatchers.notNullValue;
import static org.junit.Assert.assertThat;
import static org.junit.matchers.JUnitMatchers.containsString;

import java.util.jar.Manifest;

import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;

import org.junit.Test;

public class ManifestUtilTest {

	@Test
	public void testLoadJAR() {
		final Manifest mf = ManifestUtl.loadJAR(ManifestUtilTest.class);
		assertThat(mf, notNullValue());
		assertThat(mf.getMainAttributes().getValue("Manifest-Version"), containsString("1.0"));
	}

	@Test(expected=SystemException.class)
	public void testLoadJAR_SystemException() {
		ManifestUtl.loadJAR(ManifestUtl.class);
	}

	@Test()
	public void testGetValue() {
		assertThat(ManifestUtl.getValue(null, "aaa"), containsString(""));
		assertThat(ManifestUtl.getValue(ManifestUtl.loadJAR(ManifestUtilTest.class), "aaa"), containsString(""));
		assertThat(ManifestUtl.getValue(ManifestUtl.loadJAR(ManifestUtilTest.class), "Manifest-Version"), containsString("1.0"));
	}

}
