/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;

public class ExcelPolicyBuilderTest {
	@SuppressWarnings("unused")
	@Mocked
	private final ExcelPolicyFactory factory = null;
	
	@Test
	public void testBuild() {
		final Policy policy1 = new Policy();
		final Policy policy2 = new Policy();
		final Policy policy3 = new Policy();
		List<Policy> list = new ArrayList<Policy>();
		list.add(policy2);
		list.add(policy3);
		
		final List<ExcelPolicy> excelPolicyList1 = new ArrayList<ExcelPolicy>();
		ExcelPolicy excelPolicy1 = new ExcelPolicy();
		excelPolicyList1.add(excelPolicy1);
		
		final List<ExcelPolicy> excelPolicyList2 = new ArrayList<ExcelPolicy>();
		ExcelPolicy excelPolicy21 = new ExcelPolicy();
		ExcelPolicy excelPolicy22 = new ExcelPolicy();
		excelPolicyList2.add(excelPolicy21);
		excelPolicyList2.add(excelPolicy22);
		
		final List<ExcelPolicy> excelPolicyList3 = new ArrayList<ExcelPolicy>();
		ExcelPolicy excelPolicy3 = new ExcelPolicy();
		excelPolicyList3.add(excelPolicy3);
		
		ExcelPolicyBuilder builder = new ExcelPolicyBuilder();
		new Expectations() {
			{
				ExcelPolicyFactory.create(policy1); result = excelPolicyList1;
				ExcelPolicyFactory.create(policy2); result = excelPolicyList2;
				ExcelPolicyFactory.create(policy3); result = excelPolicyList3;
			}
		};
		
		builder.add(policy1);
		builder.addAll(list);
		List<ExcelPolicy> actualList = builder.build();
		
		assertThat(actualList.size(), is(4));
		assertThat(actualList.get(0), is(excelPolicy1));
		assertThat(actualList.get(1), is(excelPolicy21));
		assertThat(actualList.get(2), is(excelPolicy22));
		assertThat(actualList.get(3), is(excelPolicy3));
	}
	
	@Test
	public void testBuild_PolicyZero() {
		ExcelPolicyBuilder builder = new ExcelPolicyBuilder();
		new Expectations() {
			{
			}
		};
		
		List<ExcelPolicy> actualList = builder.build();
		
		assertThat(actualList.size(), is(0));
	}
}
