/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.policylist;

/**
 * グループコンボボックスの項目を表すクラス.
 * 
 */
class GroupComboBoxItem {

    /** グループ名. */
    private String groupName;

    /** 表示ラベル */
    private String viewLabel;

    /**
     * 新しい GroupComboBoxItem を構築する.
     * 
     * @param groupName グループ名.
     * @param viewLabel 表示ラベル
     */
    GroupComboBoxItem(String groupName, String viewLabel) {
        this.groupName = groupName;
        this.viewLabel = viewLabel;
    }

    /**
     * グループ名を取得する.
     * 
     * @return グループ名.
     * 
     */
    String getGroupName() {
        return groupName;
    }

    @Override
    public String toString() {
        if (viewLabel == null) {
            return "";
        }

        return viewLabel;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GroupComboBoxItem) {
            GroupComboBoxItem itemObj = (GroupComboBoxItem) obj;
            return ((this.groupName == null && itemObj.groupName == null) || (this.groupName != null && this.groupName.equals(itemObj.groupName)));
        } else {
            return false;
        }
    }

}
