/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import jp.co.ogis_ri.citk.policytool.AppLauncher;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationException;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;

import org.apache.commons.logging.Log;
import org.springframework.core.NestedRuntimeException;

/**
 * ビュー共通例外ハンドラ.
 * 
 */
public class ViewExceptionHandler {
    /**
     * ロガー
     */
    private static final Log logger =
            LogWrapperFactory.getLog(AppLauncher.class);

    /**
     * 操作の処理を行う.
     * 
     * @param e 例外.
     */
    public void handle(Throwable e) {
        try {
            logger.error(e.getMessage(), e.getCause());
            if (e instanceof ApplicationException) {
                MessageDialog.showApplicationException(ApplicationException.class.cast(e));
            } else if (e instanceof SystemException) {
                MessageDialog.showSystemException(SystemException.class.cast(e));
                System.exit(-1);
            } else if (e instanceof NestedRuntimeException) {
                MessageDialog.showNestedRuntimeException(NestedRuntimeException.class.cast(e));
                System.exit(-1);
            }

            else {
                MessageDialog.showException(e);
                System.exit(-1);
            }
        } catch (Exception ex) {
            logger.fatal(ex, ex.getCause());
            System.exit(-1);
        }
    }
}
