/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.service.policylist;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policylist.model.PolicyView;

/**
 * ポリシー一覧サービスのインターフェース.
 */
public interface PolicyListService {
    /**
     * Open AMのデータと再取得し、ツール上のデータを更新する.
     * 
     */
    void refresh();

    /**
     * レルムのリストを取得する.
     * 
     * @return レルムリスト.
     * 
     */
    List<Realm> findRealms();

    /**
     * 指定されたレルムに対応する Group のリストを取得する.
     * 
     * @param realm レルム.
     * @return Group のリスト.
     * 
     */
    List<String> findGroupNames(Realm realm);

    /**
     * 指定されたレルムに対応する参照ポリシーリストを取得する.
     * 
     * @param realm レルム
     * @return 参照ポリシーリスト.
     * 
     */
    List<Referral> findReferrals(Realm realm);

    /**
     * 指定された検索条件でポリシーリストを取得する.
     * 
     * @param realmName レルム名(nullの場合、未指定).
     * @param groupName グループ名(nullの場合、未指定).
     * @param resourceUrl リソース URL(nullの場合、未指定).
     * @return 検索条件にマッチするポリシーリスト.
     * 
     */
    List<PolicyView> findPolicies(String realmName, String groupName,
            String resourceUrl);

    /**
     * 指定されたポリシーの削除処理を行う.
     * 
     * @param policy ポリシー.
     * 
     */
    void delete(Policy policy);
}
