/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * Policyが1個以上のリソースを持つかをチェックする相関項目チェックの, 検証アノテーション.
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {RuleResourceSize.Validator.class})
public @interface RuleResourceSize {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceSize.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        RuleResourceSize[] value();
    }

    /**
     * バリデータ.
     */
    class Validator implements
            ConstraintValidator<RuleResourceSize, PolicyValidModel> {
        @Override
        public void initialize(RuleResourceSize arg0) {
        }

        @Override
        public boolean isValid(PolicyValidModel arg0,
                ConstraintValidatorContext arg1) {
            // Policy は、1つ以上のリソースを持つこと
            if (arg0.getTarget().getResources().size() >= 1) {
                return true;
            } else {
                arg1.disableDefaultConstraintViolation();
                String messageTemplate =
                        arg1.getDefaultConstraintMessageTemplate();
                ConstraintViolationBuilder builder =
                        arg1.buildConstraintViolationWithTemplate(messageTemplate
                                + Integer.toString(arg0.getTarget()
                                        .getResources()
                                        .size()));
                builder.addNode("policy")
                        .addNode("resources")
                        .addNode("size")
                        .addConstraintViolation();

                return false;
            }
        }
    }
}
