/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.constraints.Pattern;

/**
 * Permitの単項目チェックの検証アノテーション.
 * 
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {})
@Pattern(regexp = "ALLOW|DENY|INDETERMINATE", message = "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.PermitAnnotation.Pattern.message.default}")
public @interface PermitAnnotation {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.PermitAnnotation.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.FIELD})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        PermitAnnotation[] value();
    }
}
