/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>
 * Java class for anonymous complex type.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{}ServiceName" minOccurs="0"/>
 *         &lt;element ref="{}ResourceName" minOccurs="0"/>
 *         &lt;element ref="{}AttributeValuePair" maxOccurs="2" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"serviceName", "resourceName",
        "attributeValuePair"})
@XmlRootElement(name = "Rule")
public class OpenAMRule {

    @XmlElement(name = "ServiceName")
    protected OpenAMServiceName serviceName;
    @XmlElement(name = "ResourceName")
    protected OpenAMResourceName resourceName;
    @XmlElement(name = "AttributeValuePair")
    protected List<OpenAMAttributeValuePair> attributeValuePair;
    @XmlAttribute(required = true)
    protected String name;

    /**
     * Gets the value of the serviceName property.
     * 
     * @return possible object is {@link OpenAMServiceName }
     * 
     */
    public OpenAMServiceName getServiceName() {
        return serviceName;
    }

    /**
     * Sets the value of the serviceName property.
     * 
     * @param value allowed object is {@link OpenAMServiceName }
     * 
     */
    public void setServiceName(OpenAMServiceName value) {
        this.serviceName = value;
    }

    /**
     * Gets the value of the resourceName property.
     * 
     * @return possible object is {@link OpenAMResourceName }
     * 
     */
    public OpenAMResourceName getResourceName() {
        return resourceName;
    }

    /**
     * Sets the value of the resourceName property.
     * 
     * @param value allowed object is {@link OpenAMResourceName }
     * 
     */
    public void setResourceName(OpenAMResourceName value) {
        this.resourceName = value;
    }

    /**
     * Gets the value of the attributeValuePair property.
     * 
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the attributeValuePair property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getAttributeValuePair().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OpenAMAttributeValuePair }
     * 
     * 
     */
    public List<OpenAMAttributeValuePair> getAttributeValuePair() {
        if (attributeValuePair == null) {
            attributeValuePair = new ArrayList<OpenAMAttributeValuePair>();
        }
        return this.attributeValuePair;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setName(String value) {
        this.name = value;
    }

}
