/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

import org.junit.Test;

public class PolicyBuilderTest {
	@Test
	public void testBuild() {
		ExcelPolicy excelPolicy1 = new ExcelPolicy();
		excelPolicy1.setRealmName("realm1");
		excelPolicy1.setPolicyName("policy1");
		excelPolicy1.setResourceUrl("http://www.example.com/");
		excelPolicy1.setGetPermitValue("ALLOW");
		excelPolicy1.setPostPermitValue("DENY");
		excelPolicy1.setSubject("id=sbj1,i=2");
		
		ExcelPolicy excelPolicy2 = new ExcelPolicy();
		excelPolicy2.setRealmName("realm1");
		excelPolicy2.setPolicyName("policy1");
		excelPolicy2.setResourceUrl("http://www.example2.com/");
		excelPolicy2.setGetPermitValue("INDETERMINATE");
		excelPolicy2.setPostPermitValue("ALLOW");
		excelPolicy2.setSubject(null);
		
		ExcelPolicy excelPolicy3 = new ExcelPolicy();
		excelPolicy3.setRealmName("realm1");
		excelPolicy3.setPolicyName("policy1");
		excelPolicy3.setResourceUrl(null);
		excelPolicy3.setGetPermitValue(null);
		excelPolicy3.setPostPermitValue(null);
		excelPolicy3.setSubject("id=sbj3,i=3");
		
		PolicyBuilder builder = new PolicyBuilder();
		builder.add(excelPolicy1);
		builder.add(excelPolicy2);
		builder.add(excelPolicy3);
		List<Policy> policies = builder.build();
		
		assertThat(policies.size(), is(1));
		Policy policy = policies.get(0);
		assertThat(policy.getPolicyName(), is("policy1"));
		assertThat(policy.getRealmName(), is("realm1"));
		
		assertThat(policy.getResources().size(), is(2));
		Resource resource1 = policy.getResources().get(0);
		assertThat(resource1.getResourceUrl(), is("http://www.example.com/"));
		assertThat(resource1.getGetPermitValue(), is("ALLOW"));
		assertThat(resource1.getPostPermitValue(), is("DENY"));
		Resource resource2 = policy.getResources().get(1);
		assertThat(resource2.getResourceUrl(), is("http://www.example2.com/"));
		assertThat(resource2.getGetPermitValue(), is("INDETERMINATE"));
		assertThat(resource2.getPostPermitValue(), is("ALLOW"));
		
		assertThat(policy.getSubjects().size(), is(2));
		Subject subject1 = policy.getSubjects().get(0);
		assertThat(subject1.getSubjectName(), is("sbj1"));
		assertThat(subject1.getSubjectCode(), is("id=sbj1,i=2"));
		Subject subject2 = policy.getSubjects().get(1);
		assertThat(subject2.getSubjectName(), is("sbj3"));
		assertThat(subject2.getSubjectCode(), is("id=sbj3,i=3"));
	}

	@Test
	public void testBuild_ResourceUrl_Or_GetPermit_Or_PostPermit_Is_NULL() {
		ExcelPolicy excelPolicy1 = new ExcelPolicy();
		excelPolicy1.setRealmName("realm1");
		excelPolicy1.setPolicyName("policy1");
		excelPolicy1.setResourceUrl("http://www.example.com/");
		excelPolicy1.setGetPermitValue(null);
		excelPolicy1.setPostPermitValue(null);
		
		ExcelPolicy excelPolicy2 = new ExcelPolicy();
		excelPolicy2.setRealmName("realm1");
		excelPolicy2.setPolicyName("policy1");
		excelPolicy2.setResourceUrl(null);
		excelPolicy2.setGetPermitValue("INDETERMINATE");
		excelPolicy2.setPostPermitValue(null);
		
		ExcelPolicy excelPolicy3 = new ExcelPolicy();
		excelPolicy3.setRealmName("realm1");
		excelPolicy3.setPolicyName("policy1");
		excelPolicy3.setResourceUrl("http://www.example2.com/");
		excelPolicy3.setGetPermitValue(null);
		excelPolicy3.setPostPermitValue(null);
		
		PolicyBuilder builder = new PolicyBuilder();
		builder.add(excelPolicy1);
		builder.add(excelPolicy2);
		builder.add(excelPolicy3);
		List<Policy> policies = builder.build();
		
		Policy policy = policies.get(0);
		assertThat(policy.getResources().size(), is(0));
	}

	@Test
	public void testBuild_ZERO() {
		PolicyBuilder builder = new PolicyBuilder();
		List<Policy> policies = builder.build();
		
		assertThat(policies.size(), is(0));
	}
}
