/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * オートコンプリート機能の DocumentListener.
 */
public class AutoCompleteDocumentListener implements DocumentListener {

    /** コンボボックス. */
    private JComboBox comboBox;

    /** コンボボックス選択変更時のロック用オブジェクト. */
    private Object editingLocker;

    /**
     * 新しい AutoCompleteDocumentListener を構築する.
     * 
     * @param comboBox 操作対象のコンボボックス.
     */
    public AutoCompleteDocumentListener(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.editingLocker = new Object();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {

        // このリスナ自身が編集中でなく, かつ, コンボボックス選択変更後でない場合に, 検索・選択処理を実行
        searchAndSelect();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /**
     * 入力されたテキストからコンボボックス項目を検索し, 選択する.
     * 
     */
    private void searchAndSelect() {

        final JTextField comboBoxTextEditor =
                (JTextField) comboBox.getEditor().getEditorComponent();
        final ComboBoxModel comboBoxModel = comboBox.getModel();

        // 既に現在のテキストと選択テキストが同一の場合は, 以後の処理は行わないで打ち切り
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex != -1) {
            String comboBoxTextEditorText = comboBoxTextEditor.getText();
            String comboBoxSelectedText =
                    comboBox.getItemAt(selectedIndex).toString();

            if (comboBoxTextEditorText.equals(comboBoxSelectedText)) {
                return;
            }
        }

        // 選択テキストと同一でない場合は, 検索処理を行い, 見つかった場合は, その項目を選択.
        final int index =
                ComboBoxModelUtil.getSelectionForKey(comboBoxModel,
                        selectedIndex, comboBoxTextEditor.getText());
        if (index != -1) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    synchronized (editingLocker) {
                        int caretPosition =
                                comboBoxTextEditor.getCaretPosition();

                        if (comboBox.getSelectedIndex() == index) {
                            comboBoxTextEditor.setText(comboBoxModel.getElementAt(
                                    index)
                                    .toString());
                        } else {
                            // ここでテキストの値も変えられる。
                            comboBox.setSelectedIndex(index);
                        }

                        comboBoxTextEditor.setCaretPosition(caretPosition);
                        comboBoxTextEditor.setSelectionStart(caretPosition);
                        comboBoxTextEditor.setSelectionEnd(comboBoxTextEditor.getText()
                                .length());

                        comboBox.showPopup();
                    }
                }
            });
        }
    }
}
