/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * サブジェクトがレルムドメインのグループに存在することをチェックする相関項目チェックの, 検証アノテーション.
 * 
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {RuleSubjectDependOnRealm.Validator.class})
public @interface RuleSubjectDependOnRealm {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectDependOnRealm.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        RuleUrlDependOnRealm[] value();
    }

    /**
     * バリデータ.
     */
    class Validator implements
            ConstraintValidator<RuleSubjectDependOnRealm, PolicyValidModel> {
        @Override
        public void initialize(RuleSubjectDependOnRealm arg0) {
        }

        @Override
        public boolean isValid(PolicyValidModel arg0,
                ConstraintValidatorContext arg1) {
            // そのサブジェクトは、レルムドメインのグループに存在すること
            int i = 0;
            for (Subject subject : arg0.getTarget().getSubjects()) {
                String subjectFullName =
                        subject.getSubjectName() + "("
                                + subject.getSubjectCode() + ")";
                if (!arg0.getGroups().contains(subjectFullName)) {
                    arg1.disableDefaultConstraintViolation();
                    String messageTemplate =
                            arg1.getDefaultConstraintMessageTemplate();
                    ConstraintViolationBuilder builder =
                            arg1.buildConstraintViolationWithTemplate(messageTemplate
                                    + subjectFullName);
                    builder.addNode("policy")
                            .addNode("subjects")
                            .addNode("subjectName")
                            .inIterable()
                            .atIndex(i)
                            .addConstraintViolation();

                    return false;
                }
                i++;
            }

            return true;
        }
    }
}
