/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * リソースのGET,POST権限のうちいずれかはINDETERMINATEでないことをチェックする相関項目チェックの, 検証アノテーション.
 * 
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {RuleResourceValidPermit.Validator.class})
public @interface RuleResourceValidPermit {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceValidPermit.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        RuleResourceValidPermit[] value();
    }

    /**
     * バリデータ.
     */
    class Validator implements
            ConstraintValidator<RuleResourceValidPermit, PolicyValidModel> {

        @Override
        public void initialize(RuleResourceValidPermit arg0) {
        }

        @Override
        public boolean isValid(PolicyValidModel arg0,
                ConstraintValidatorContext arg1) {

            int i = 0;
            for (Resource resource : arg0.getTarget().getResources()) {
                if (resource.getGetPermit() == Permit.INDETERMINATE
                        && resource.getPostPermit() == Permit.INDETERMINATE) {

                    arg1.disableDefaultConstraintViolation();
                    String messageTemplate =
                            arg1.getDefaultConstraintMessageTemplate();
                    ConstraintViolationBuilder builder =
                            arg1.buildConstraintViolationWithTemplate(messageTemplate
                                    + resource.getResourceUrl());
                    builder.addNode("policy")
                            .addNode("resources")
                            .addNode("resourcesUrl")
                            .inIterable()
                            .atIndex(i)
                            .addConstraintViolation();
                    return false;
                }
                i++;
            }
            return true;
        }
    }
}
