/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * OpenAMAccess の処理における例外.
 * 
 */
public class OpenAMAccessException extends ApplicationException {

    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * ssoadmの終了コード.
     */
    private int exitCode;

    /**
     * ssoadmの終了コードを取得する.
     * 
     * @return ssoadmの終了コード.
     */
    public int getExitCode() {
        return exitCode;
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     * @param cause この例外の原因となった例外.
     */
    public OpenAMAccessException(MessageInfo messageInfo, Throwable cause) {
        super(messageInfo, cause);
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     */
    public OpenAMAccessException(MessageInfo messageInfo) {
        super(messageInfo);
    }

    /**
     * コンストラクタ.
     * 
     * @param exitCode ssoadmの終了コード.
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public OpenAMAccessException(int exitCode, String code, Object... args) {
        super(code, args);
        this.exitCode = exitCode;
    }

    /**
     * コンストラクタ.
     * 
     * @param exitCode ssoadmの終了コード.
     * @param cause この例外の原因となった例外.
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public OpenAMAccessException(int exitCode, Throwable cause, String code,
            Object... args) {
        super(cause, code, args);
        this.exitCode = exitCode;
    }
}
