/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * このアプリケーションで処理する例外のうち, 情報を画面に表示し処理を続行するように振舞う例外.
 * 
 */
public class ApplicationException extends RuntimeException {

    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * メッセージ情報.
     */
    private MessageInfo messageInfo;

    /**
     * メッセージ情報を取得する.
     * 
     * @return メッセージ情報.
     */
    public MessageInfo getMessageInfo() {
        return messageInfo;
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     */
    public ApplicationException(MessageInfo messageInfo) {
        super(messageInfo.toString());
        this.messageInfo = messageInfo;
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     * @param cause この例外の原因となった例外.
     */
    public ApplicationException(MessageInfo messageInfo, Throwable cause) {
        super(messageInfo.toString(), cause);
        this.messageInfo = messageInfo;
    }

    /**
     * コンストラクタ.
     * 
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public ApplicationException(String code, Object... args) {
        this(new MessageInfo(code, args));
    }

    /**
     * コンストラクタ.
     * 
     * @param cause この例外の原因となった例外.
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public ApplicationException(Throwable cause, String code, Object... args) {
        this(new MessageInfo(code, args), cause);
    }
}
