/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl.model;

import java.util.ArrayList;
import java.util.List;

/**
 * ExcelPolicy モデル
 *
 */
public class ExcelPolicy {

    /**
     * このモデルの項目数.
     */
    public static final int ITEM_SIZE = 6;

    /**
     * レルム名.
     */
    private String realmName = null;

    /**
     * ポリシー名.
     */
    private String policyName = null;

    /**
     * リソースURL.
     */
    private String resourceUrl = null;

    /**
     * GET 権限文字列.
     */
    private String getPermitValue = null;

    /**
     * POST 権限文字列.
     */
    private String postPermitValue = null;

    /**
     * サブジェクトコード. サブジェクト名ではなく, サブジェクトコードを格納.
     */
    private String subject = null;

    /**
     * レルム名を取得する.
     * 
     * @return レルム名.
     */
    public String getRealmName() {
        return realmName;
    }

    /**
     * レルム名を設定する.
     * 
     * @param realmName レルム名.
     */
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    /**
     * ポリシー名を取得する.
     * 
     * @return ポリシー名.
     */
    public String getPolicyName() {
        return policyName;
    }

    /**
     * ポリシー名を設定する.
     * 
     * @param policyName ポリシー名.
     */
    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    /**
     * リソースURLを取得する.
     * 
     * @return リソースURL.
     */
    public String getResourceUrl() {
        return resourceUrl;
    }

    /**
     * リソースURLを設定する.
     * 
     * @param resourceUrl リソースURL.
     */
    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    /**
     * GET 権限文字列を取得する.
     * 
     * @return GET 権限文字列.
     */
    public String getGetPermitValue() {
        return getPermitValue;
    }

    /**
     * GET 権限文字列を設定する.
     * 
     * @param getPermitValue GET 権限文字列.
     */
    public void setGetPermitValue(String getPermitValue) {
        this.getPermitValue = getPermitValue;
    }

    /**
     * POST 権限文字列を取得する.
     * 
     * @return POST 権限文字列.
     */
    public String getPostPermitValue() {
        return postPermitValue;
    }

    /**
     * POST 権限文字列を設定する.
     * 
     * @param postPermitValue POST 権限文字列.
     */
    public void setPostPermitValue(String postPermitValue) {
        this.postPermitValue = postPermitValue;
    }

    /**
     * サブジェクトコードを取得する.
     * 
     * @return サブジェクトコード.
     */
    public String getSubject() {
        return subject;
    }

    /**
     * サブジェクトコードを設定する.
     * 
     * @param subject サブジェクトコード.
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * コンストラクタ.
     */
    public ExcelPolicy() {
        super();
    }

    /**
     * このExcelPolicyを, 文字列値のリストに変換する.
     * 
     * @return 文字列値のリスト.
     */
    public List<String> toValues() {
        List<String> values = new ArrayList<String>();
        values.add(realmName);
        values.add(policyName);
        values.add(resourceUrl);
        values.add(getPermitValue);
        values.add(postPermitValue);
        values.add(subject);
        return values;
    }
}
