/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * PolicyからExcelPolicyを作成するクラス.
 * 
 */
class ExcelPolicyBuilder {
    /**
     * ExcelPolicyの作成に使用するPolicyのリスト.
     */
    private List<Policy> policies = new ArrayList<Policy>();

    /**
     * Policyを追加する.
     * 
     * @param policy 追加するPolicy.
     */
    public void add(Policy policy) {
        policies.add(policy);
    }

    /**
     * リスト中のPolicyをすべて追加する.
     * 
     * @param list 追加するPolicyを含むリスト.
     */
    public void addAll(List<Policy> list) {
        policies.addAll(list);
    }

    /**
     * 現在のPolicyのリストから, ExcelPolicyを作成する.
     * 
     * @return 作成されたExcelPolicyのリスト.
     */
    public List<ExcelPolicy> build() {
        List<ExcelPolicy> list = new ArrayList<ExcelPolicy>();
        for (Policy policy : policies) {
            list.addAll(ExcelPolicyFactory.create(policy));
        }
        return list;
    }
}
