/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common;

/**
 * ポリシー定義ツールの共通定数クラス.
 */
public class CommonConstants {
    /**
     * OPENAM SSOADM URL
     */
    public static final String PROP_KEY_OPENAM_SSOADM_URL = "openam.ssoadm.url";

    /**
     * OPENAM USER ID
     */
    public static final String PROP_KEY_OPENAM_USERID = "openam.userid";

    /**
     * OPENAM PASSOWRD
     */
    public static final String PROP_KEY_OPENAM_PASSWORD = "openam.password";

    /**
     * OPENAM ENCODING
     */
    public static final String PROP_KEY_OPENAM_ENCODING = "openam.encoding";

    /**
     * ダイアログ： 致命的なシステムエラー
     */
    public static final String DIALOG_TITLE_ERROR = "common.dialog.title.error";

    /**
     * ダイアログ： 警告
     */
    public static final String DIALOG_TITLE_WARN = "common.dialog.title.warn";

    /**
     * ダイアログ： 情報
     */
    public static final String DIALOG_TITLE_INFO = "common.dialog.title.info";

    /**
     * ダイアログ： 確認
     */
    public static final String DIALOG_TITLE_CONFIRM =
            "common.dialog.title.confirm";

    /**
     * Excel拡張子
     */
    public static final String EXT_EXCEL = "xls";

    /**
     * テンプレートファイル名.
     */
    public static final String TMPL_NAME = "/policy.xlt";

    /**
     * テンプレートのシートインデックス.
     */
    public static final int TMPL_SHEET_INDEX = 0;

    /**
     * テンプレートの行オフセット.
     */
    public static final int TMPL_SHEET_ROW_OFFSET = 1;

    /**
     * テンプレートの列オフセット.
     */
    public static final int TMPL_SHEET_COLUMN_OFFSET = 0;

}
